package etradeproject;

import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;
import java.util.*;
import java.sql.*;

public class login extends HttpServlet
{
  static final private String CONTENT_TYPE = "text/html; charset=windows-1251";
  //Initialize global variables
  public void init() throws ServletException
  {
  }

  private String getParameter(HttpServletRequest request, String name)
  {
    if(request.getParameter(name)==null || request.getParameter(name.trim()).equals(""))
      return null;

    return request.getParameter(name);
  }

  //Process the HTTP Get request
  public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
  {
    request.setCharacterEncoding("windows-1251");
    response.setContentType(CONTENT_TYPE);

    String userName = getParameter(request, "userName");
    String password = getParameter(request, "password");

    User user = null;

    Basket basket = new Basket();
    boolean haveOldProducts = false;

    try
    {
      Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
      Connection con = DriverManager.getConnection("jdbc:odbc:storeDB", "sa", "");
      Statement stmt = con.createStatement();

      ResultSet rs = stmt.executeQuery("SELECT * FROM Users WHERE user_name = '" + userName + "' AND password = '" + password + "'");

      if(!rs.next())
      {
        rs.close();
        stmt.close();
        con.close();

        request.getSession().setAttribute("errorValue", "   / !      !");

        response.sendRedirect("index.jsp?error=true");

        return;
      }

      user = new User(rs.getInt("user_id"), rs.getString("first_name"),
                      rs.getString("last_name"), rs.getString("city"),
                      rs.getString("address"), rs.getString("e_mail"),
                      rs.getString("user_name"), rs.getString("password"));

      request.getSession().setAttribute("user", user);

      Cookie userCookie = new Cookie("userName", java.net.URLEncoder.encode(user.getUserName()));
      userCookie.setMaxAge(60*60*24*30); //time to  expire - 30 days
      response.addCookie(userCookie);

      rs = stmt.executeQuery("SELECT p.product_id,  p.name, p.description, convert(numeric(10, 3), p.price) price, p.picture_url, m.measure, c.category, c.category_id, convert(numeric(10, 3), op.quantity) quantity, o.order_id " +
                             "FROM Products p, Measures m, Categories c, OrderProduct op, Orders o " +
                             "WHERE p.measure_id = m.measure_id " +
                             "AND p.category_id = c.category_id " +
                             "AND op.product_id = p.product_id " +
                             "AND op.order_id = o.order_id " +
                             "AND o.user_id = " + user.getUserId() + " " +
                             "AND o.completed = 0");

      Long orderId = null;
      while(rs.next())
      {
        Product product = new Product(rs.getInt(1), rs.getString(2), rs.getString(3),
            rs.getFloat(4), rs.getString(5), rs.getString(6), rs.getString(7), rs.getInt(8));

        basket.addToBasket(product, rs.getFloat(9));

        orderId = new Long(rs.getLong(10));

        haveOldProducts = true;
      }

      request.getSession().setAttribute("orderId", orderId);
      request.getSession().setAttribute("basket", basket);
      if(haveOldProducts)
        request.getSession().setAttribute("checkForOldProducts", "1");

      rs.close();
      stmt.close();
      con.close();
    }
    catch (Exception ex)
    {
      request.getSession().setAttribute("errorValue", "  : " + ex.toString() + "!");

      response.sendRedirect("index.jsp?error=true");

      return;
    }

    response.sendRedirect("index.jsp");
  }

  //Process the HTTP Post request
  public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
  {
    doGet(request, response);
  }
  //Clean up resources
  public void destroy()
  {
  }
}